/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.eap.cloudsdk.httpclient;

import com.tplink.eap.cloudsdk.CustomSSLContext;
import com.tplink.eap.cloudsdk.LogCenter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public abstract class CustomHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(CustomHttpClient.class);
    protected static final int DEFAULT_CONN_TIMEOUT = 35;
    protected static final int DEFAULT_READ_TIMEOUT = 30;
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final int DEFAULT_CONN_REQUEST_TIMEOUT = 35;
    private static final int CONN_MAX_TOTAL = 20;
    private static final int MAX_PER_ROUTE = 5;
    private static final long MAX_IDLE_TIME = 300L;
    private PoolingHttpClientConnectionManager connMgr;
    private HttpClientBuilder clientBuilder;

    public CustomHttpClient() {
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(CustomSSLContext.getSSLContext())).build();
        this.connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        this.connMgr.setMaxTotal(20);
        this.connMgr.setDefaultMaxPerRoute(5);
        this.clientBuilder = HttpClients.custom().evictExpiredConnections().evictIdleConnections(300L, TimeUnit.SECONDS).setConnectionManager((HttpClientConnectionManager)this.connMgr);
    }

    public String sendPostRequest(String url, Map<String, String> headers, String request, int connTimeout, int readTimeout) throws IOException {
        block27: {
            HttpEntity resEntity;
            CloseableHttpResponse httpResponse;
            block28: {
                if (url == null || request == null) {
                    logger.error("Invalid parameter.");
                    return null;
                }
                RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(35000).setConnectTimeout(35000).setSocketTimeout(30000).build();
                HttpPost httpPost = new HttpPost(url);
                if (headers != null) {
                    for (String key : headers.keySet()) {
                        httpPost.addHeader(key, headers.get(key));
                    }
                }
                httpPost.setEntity((HttpEntity)new StringEntity(request.toString(), CHARSET_UTF8));
                httpPost.setConfig(requestConfig);
                CloseableHttpClient httpClient = this.clientBuilder.build();
                httpResponse = null;
                resEntity = null;
                BufferedReader in = null;
                if (logger.isDebugEnabled()) {
                    if (LogCenter.getLogAll()) {
                        logger.debug("url is {}.", (Object)url);
                        logger.debug("request is {}.", (Object)request.toString());
                    } else {
                        logger.debug("Trimmed url is {}.", (Object)url.split("\\?")[0]);
                        JSONObject requestObj = JSONObject.fromObject((Object)request);
                        if (requestObj != null && requestObj.has("method")) {
                            logger.debug("Method of request is {}.", (Object)requestObj.getString("method"));
                        }
                    }
                }
                if ((httpResponse = httpClient.execute((HttpUriRequest)httpPost)) == null) break block27;
                if (httpResponse.getStatusLine().getStatusCode() != HttpStatus.OK.value()) break block28;
                resEntity = httpResponse.getEntity();
                StringBuilder response = new StringBuilder();
                in = new BufferedReader(new InputStreamReader(resEntity.getContent(), CHARSET_UTF8));
                String line = null;
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
                if (logger.isDebugEnabled()) {
                    if (LogCenter.getLogAll()) {
                        logger.debug("response is {}", (Object)response.toString());
                    } else {
                        JSONObject responseObj = JSONObject.fromObject((Object)response.toString());
                        if (responseObj != null && responseObj.optInt("error_code") == 0) {
                            logger.debug("response is OK.");
                        } else {
                            logger.debug("response is {}", (Object)response.toString());
                        }
                    }
                }
                String string = response.toString();
                try {
                    if (resEntity != null) {
                        EntityUtils.consume((HttpEntity)resEntity);
                    }
                    if (httpResponse != null) {
                        httpResponse.close();
                    }
                }
                catch (IOException ex) {
                    logger.error(ex.toString(), (Throwable)ex);
                }
                return string;
            }
            try {
                logger.warn("Response status for post request is {}.", (Object)httpResponse.getStatusLine().getStatusCode());
            }
            finally {
                try {
                    if (resEntity != null) {
                        EntityUtils.consume(resEntity);
                    }
                    if (httpResponse != null) {
                        httpResponse.close();
                    }
                }
                catch (IOException ex) {
                    logger.error(ex.toString(), (Throwable)ex);
                }
            }
        }
        return null;
    }

    public static String parseHost(String url) {
        Pattern urlPattern;
        Matcher urlMatcher;
        if (url != null && (urlMatcher = (urlPattern = Pattern.compile("^(https?:\\/\\/)?([a-zA-Z0-9\\.]+)(:(\\d{1,5}))?(\\/.*)?$")).matcher(url)).matches()) {
            return urlMatcher.group(2);
        }
        return null;
    }
}

